

#ifdef STAGE0
#else
const bool colortex6MipmapEnabled = true;
#endif

varying vec2 texcoord;



#define FAST_BLUR

#ifdef FAST_BLUR

vec3 blur(sampler2D tex, vec2 dir, vec2 uv)
{
    #ifdef STAGE0
    float lod = 4.5;
    #else
    float lod = 1.5;
    #endif

    // Calculate noise once and create offset
    float noise = mix(R2_dither(gl_FragCoord.xy), 0.5, 0.5);
    vec2 jitter = (noise - 0.5) * texelSize * 8.0; // Center noise around 0
    dir += jitter;

    // Hexagonal sampling pattern
    const float angle = 1.047197551; // 60 degrees

    vec3 acc = textureLod(tex, uv, lod).rgb;

    for (int i = 0; i < 4; i++)
    {
        float a = angle * float(i);
        vec2 offset = vec2(cos(a), sin(a)) * dir * 3.0;
        acc += textureLod(tex, uv + offset, lod).rgb;
    }

    return acc * 0.2;
}
#else
vec3 blur(sampler2D tex, vec2 dir, vec2 uv)
{
    float sigma = 4.0;
    sigma += blueNoise(gl_FragCoord.xy) * 0.25; // 0‥1 blue-noise

    float sigma2 = sigma * sigma;
    int support = int(sigma * 3.0);

    float norm = min(1.0, 1.0 / (sqrt(2.0 * PI) * sigma));

    vec3 g;
    g.x = 1.0;
    g.y = exp(-0.5 / sigma2);
    g.z = g.y * g.y;

    // accumulate center pixel color first
    vec3 acc = texture(tex, uv).rgb;

    for (int i = 1; i <= support;)
    {
        // calculate 2 gaussian coefficients per loop
        float coeff1, coeff2;
        g.xy *= g.yz;
        coeff1 = g.x;
        g.xy *= g.yz;
        coeff2 = g.x;
        i += 2;

        // use hardware linear filtering to sample with both coefficients at once
        float weight = coeff1 + coeff2;
        vec2 offset = (float(i - 2) + (coeff2 / weight)) * dir;
        acc += texture(tex, uv - offset, 1.5).rgb * weight;
        acc += texture(tex, uv + offset, 1.5).rgb * weight;
    }
    acc *= norm;
    return acc;
}

#endif

/* DRAWBUFFERS:6 */

void main()
{
    vec3 result;

#ifndef STAGE0
#endif

#ifdef STAGE0
    // Horizontal pass on the full-resolution texture.

    vec2 dir = vec2(texelSize.x, 0.0) * 8;

    result = blur(colortex4, dir, texcoord).xyz;

#else
    // Vertical pass on the quarter-resolution texture using the optimized approach.

    vec2 dir = vec2(0.0, texelSize.y) * 8;

    result = blur(colortex6, dir, texcoord).xyz;

#endif

    gl_FragData[0].rgb = result * 0.25;
}
